/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.structures.items.StructureItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class StructureConfiguration {
    public static String houseFacingName = "House Facing";
    private static String hitXTag = "hitX";
    private static String hitYTag = "hitY";
    private static String hitZTag = "hitZ";
    private static String houseFacingTag = "wareHouseFacing";
    public EnumFacing houseFacing;
    public BlockPos pos;

    public StructureConfiguration() {
        this.Initialize();
    }

    public void Initialize() {
        this.houseFacing = EnumFacing.NORTH;
    }

    public NBTTagCompound WriteToNBTTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.pos != null) {
            tag.func_74768_a(hitXTag, this.pos.func_177958_n());
            tag.func_74768_a(hitYTag, this.pos.func_177956_o());
            tag.func_74768_a(hitZTag, this.pos.func_177952_p());
        }
        tag.func_74778_a(houseFacingTag, this.houseFacing.func_176610_l());
        tag = this.CustomWriteToCompoundNBT(tag);
        return tag;
    }

    public StructureConfiguration ReadFromCompoundNBT(NBTTagCompound messageTag) {
        return null;
    }

    public StructureConfiguration ReadFromCompoundNBT(NBTTagCompound messageTag, StructureConfiguration config) {
        if (messageTag != null) {
            if (messageTag.func_74764_b(hitXTag)) {
                config.pos = new BlockPos(messageTag.func_74762_e(hitXTag), messageTag.func_74762_e(hitYTag), messageTag.func_74762_e(hitZTag));
            }
            if (messageTag.func_74764_b(houseFacingTag)) {
                config.houseFacing = EnumFacing.func_176739_a((String)messageTag.func_74779_i(houseFacingTag));
            }
            this.CustomReadFromNBTTag(messageTag, config);
        }
        return config;
    }

    public void BuildStructure(EntityPlayer player, WorldServer world) {
        BlockPos hitBlockPos = this.pos;
        this.ConfigurationSpecificBuildStructure(player, world, hitBlockPos);
    }

    protected void ConfigurationSpecificBuildStructure(EntityPlayer player, WorldServer world, BlockPos hitBlockPos) {
    }

    protected NBTTagCompound CustomWriteToCompoundNBT(NBTTagCompound tag) {
        return tag;
    }

    protected void CustomReadFromNBTTag(NBTTagCompound messageTag, StructureConfiguration config) {
    }

    protected void RemoveStructureItemFromPlayer(EntityPlayer player, StructureItem item) {
        player.field_71071_by.func_174925_a((Item)item, -1, 1, null);
        player.field_71069_bz.func_75142_b();
    }

    protected void DamageHeldItem(EntityPlayer player, StructureItem item) {
        ItemStack stack = player.func_184586_b(EnumHand.OFF_HAND);
        if (stack.func_77973_b() != item) {
            stack = player.func_184586_b(EnumHand.MAIN_HAND);
        }
        if (stack.func_77973_b() == item) {
            stack.func_77972_a(1, (EntityLivingBase)player);
            player.field_71069_bz.func_75142_b();
        }
    }
}

